import math

def factor(a): # Slow factorization but a is small
    res = []
    currp = 2 # Current prime factor
    currc = 0 # Current prime factor count
    while a != 1:
        # Try all possible divisors, again slow
        # as we do not stop at sqrt but now no
        # need for case distinction between
        # prime and composite
        for d in range(currp, a + 1):
            if d > currp:
                if currc > 0:
                    res.append((currp, currc))
                currc = 0
                currp = d
            if a % d == 0:
                currc += 1
                a //= d
                break
    # Add last running count after we hit 1
    if currc > 0:
        res.append((currp, currc))
    return res

# Read input
a, n = [int(i) for i in input().split()]
primes = factor(a) # We us 10e CRT so factor a

# Result is LCM of all k for the primes
res = 1
for p, e in primes:
    # Coprime with 10 so all primes are odd: use LTE
    
    # Find initial 10^m = 1 mod p
    m = 1
    powm = 10
    while powm % p != 1:
        powm *= 10
        powm %= p
        m += 1

    # From LTE ord_p(l) = ord_p(10^ml - 1) - ord_p(10^m - 1)
    # Clearly minimal l is p^(ord_p(10^ml - 1) - ord_p(10^m - 1))
    # = p^(e*n - ord_p(10^m - 1)))

    # Hence, find ord_p(10^m - 1)
    o = 1
    while True:
        if pow(10, m, p ** (o + 1)) == 1:
            o += 1
        else:
            break

    # Find result
    kp = m
    if o < e * n:
        kp *= p ** (e * n - o)

    # Take LCM
    gcd = math.gcd(res, kp)
    res *= kp // gcd
print(res)
    
        
    
